
// システムによって実体関数が注入される
// パラメータが定義されている場合にはその値を返す。未定義の場合にはnullを返す。
Func<string, object> O;
Func<string, int?> I;
Func<string, double?> D;
Func<string, string> S;
// 指定した2つのLEG間の距離(mm)を取得
Func<int, int, double> LegLength;

// パラメータが定義されている場合にはその値を強制型変換して返す。未定義、変換失敗の場合にはnullを返す。
int? II(string paramName)
    => O(paramName) switch
    {
        null => null,
        int i => i,
        double d => (int)d,
        string s => int.TryParse(s, out int ii) ? ii : null,
    };
double? DD(string paramName)
    => O(paramName) switch
    {
        null => null,
        int i => (double)i,
        double d => d,
        string s => double.TryParse(s, out double dd) ? dd : null,
    };
string SS(string paramName)
    => O(paramName) switch
    {
        null => null,
        object o => o.ToString(),
    };

// 角度変換 ラジアン↔度
double ToRad(double angDeg)
    => angDeg * Math.PI / 180;
double ToDeg(double angRad)
    => angRad * 180 / Math.PI;

// 角度をラジアンから度に変換して比較
bool AngleEqual(double angRad, double angDeg, double eps = 0.1)
    => Math.Abs(ToDeg(angRad) - angDeg) < eps;
